//*************************************************************************************************
//
//	Description:
//		zprime.fx - Default shader for zprime mode rendering.
//								Also contains rendering for Depth of Field Z pass
//
//	<P> Copyright (c) 2007 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Tom Nettleship
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		TNettleship     04/24/2007  0.1           Created
//		AMurray		      10/20/2007  0.2           Added Depth of Field Z pass
//		TNettleship			10/23/2007	0.3						Converted to on-load rendermode behaviour binding.
//	<TABLE>
//
//*************************************************************************************************

#include "stddefs.fxh"

//-----------------------------------------------------------------------
//
// Input parameters
//

#if defined( _3DSMAX_ ) || defined(USE_WVP_CONSTANT)
// Max doesn't support viewproj as an app-supplied parameter
float4x4 worldviewproj : WorldViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
>;
#else
SHARE_PARAM float4x4 viewproj : ViewProjection
<
	bool appEdit = false;
	bool export = false;
>;
#endif

float4x4 world : World
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
	bool dynamic = true;
>;


//-----------------------------------------------------------------------
//
// Vertex Shader
//

// Input structure
struct VSINPUT
{
	float3 position : POSITION;													// Object space position
};

// Output structures
struct VSOUTPUT
{
	float4 position		: POSITION;													// View-coords position
};

struct VSOUTPUT_DOF
{
	float4 position		: POSITION;													// View-coords position
	float4 coords		: TEXCOORD0;
};


VSOUTPUT ZPrimeVertexShader( float3 pos : POSITION )
{
	VSOUTPUT _output;

#if !defined( _3DSMAX_ ) && !defined(USE_WVP_CONSTANT)
	float4x4	worldviewproj = mul( world, viewproj );
#endif

	// Calculate clip-space position of the vertex
	_output.position = mul( float4( pos, 1.0f ), worldviewproj );

	return _output;
}


VSOUTPUT_DOF ZPrimeVertexShader_DOF( float3 pos : POSITION )
{
	VSOUTPUT_DOF _output;

#if !defined( _3DSMAX_ ) && !defined(USE_WVP_CONSTANT)
	float4x4	worldviewproj = mul( world, viewproj );
#endif

	// Calculate clip-space position of the vertex
	_output.position = mul( float4( pos, 1.0f ), worldviewproj );

	_output.coords = _output.position;

	return _output;
}




//-----------------------------------------------------------------------
//
// Fragment Shaders
//

COLOUR_OUTPUT_TYPE ZPrimeFragmentShader() : COLOR0
{
	return 1.0f;
}

COLOUR_OUTPUT_TYPE ZPrimeFragmentShader_DOF( float4 coords : TEXCOORD0 ) : COLOR0
{
	return coords.z/coords.w;
}



//-----------------------------------------------------------------------
//
// Technique(s)
//

technique ZPrime
<
	bool supportsSpecialisedLighting = false;
  bool preservesGlobalState = true;
	string zprimeBehaviour	= "ERMB_RENDER";
	string zprimeTechnique	= "ZPrime";
	int    zprimeDeferredID	= 0;
>
{
	pass Pass0
	{
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx ZPrimeVertexShader();
		PixelShader = compile sce_fp_rsx ZPrimeFragmentShader();
#elif defined (_XBOX)
		VertexShader = compile vs_3_0 ZPrimeVertexShader();
		PixelShader = null;
#else
		VertexShader = compile vs_3_0 ZPrimeVertexShader();
		PixelShader = compile ps_3_0 ZPrimeFragmentShader();
#endif
	}
}

technique ZPrime_DOF
<
  bool preservesGlobalState = true;
	string zprimeDOFBehaviour	= "ERMB_RENDER";
	string zprimeDOFTechnique	= "ZPrime_DOF";
	int    zprimeDOFDeferredID	= 0;
>
{
	pass Pass0
	{
#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx ZPrimeVertexShader_DOF();
		PixelShader = compile sce_fp_rsx ZPrimeFragmentShader_DOF();
#else
		VertexShader = compile vs_3_0 ZPrimeVertexShader_DOF();
		PixelShader = compile ps_3_0 ZPrimeFragmentShader_DOF();
#endif
	}
}

